;
; Sample control file for use with TIGER 1.0
;

UUCICO: Internal 7

; REQUIRED
; This field can be set to WAFFLE, IPAD, or INTERNAL.  It specifies whether
; your are using the the WAFFLE UUCICO to do mail sessions, or using the 
; INTERNAL TIGER UUCICO to do mail sessions.
; If you use INTERNAL, you may specify a line number immediately after the 
; INTERNAL specifier, indicating the line number TIGER should use to dial out
; on.  If set to 255, TIGER will default to the highest line number configured
; with a modem (not hardwired). If set to IPAD, it will disable the internal
; dialer, and process mailing list files into batches of 100 recipients for 
; use with eSoft's Internet Protocol Adapter (IPAD)  

SCAN MINUTES: 2

; REQUIRED
; This field specifies how often, in minutes, TIGER should scan the message 
; base for mail.  This should be a value between 1 and 254

HOST:  csn

; REQUIRED
; This field contains the name of the machine you are dialing for mail
; This information is normally provided by your host provider.  It is used to
; extract DOS file names for SMTP files by deleting host name information from
; the file name.  If set to DYNAMIC (all upper case), host info will be 
; extracted from the Shere= statement received as part of the login process.

DOMAIN:  @mysystem.com

; REQUIRED
; This is your fully qualified domain name of your system.  You would normally
; register your system with the NIC with the aid of your host provider.  

ORGANIZATION: My Organization Name

; OPTIONAL
; This is an entirely optional variable identifying your company or organization.
; Appears in RFC-822 header text as Organization: My Organization Name


BOARD: internet

; REQUIRED
; This field specifies the name of the TBBS message board you will use for Internet mail.  This should match EXACTLY the text in CEDIT defining a 
; board.  Boards should be private, e-mail, and allow file attachments.
; Case and spelling must match CEDIT entry EXACTLY

UUCPIN:  g:\bbs\uuin

; REQUIRED
; This field indicates where TIGER can find incoming SMTP mail files.


UUCPOUT:  g:\bbs\uuout

; REQUIRED
; This field indicates where TIGER should put outbound SMTP mail files.


ENCLOSURE: h:\tbbs\encl

; REQUIRED
; This field specifies the path to a DIRECTORY where TBBS stores file 
; enclosures for the message base.


USERLOG: h:\tbbs

; REQUIRED
; This field specifies the path to the DIRECTORY where USERLOG.BBS and 
; USERLOG.INX are located.  The .INX file is examined with each inbound
; message to determine if such a user exists.  If not, a BOUNCE message is
; returned to sender.  TIGER must be able to find USERLOG.INX.

LOGFILE: h:\tbbs\tiger.log

; REQUIRED
; This field specifies a filepath/name where TIGER should log all activity


MAIL LOG: off

; REQUIRED
; This field can be set to ON or OFF.  It specifies whether or not the 
; TIGER UUCPg dialer should log all activity for troubleshooting purposes
; or not.  A troubleshooting aid.


UUCPNAME: boardwat

; REQUIRED.
; This is the UUCP name used by your system for UUCPg protocol sessions. 
; Typically seven characters.  This info supplied by your host provider. It is
; NOT specifically your host name or logon name, but the UNIX name of your 
; TBBS system.  Most frequent cause of mistakes in TIGER.


DIAL HOURS: 01:15  

; OPTIONAL

NO-DIAL HOURS: 08:00 17:00

; OPTIONAL
; With the Internal UUCICO, TIGER will dial the host and exchange mail
; anytime a message is sent by a user.  This field specifies how often, in 
; hours and minutes, TIGER should dial the host ANYWAY to get any inbound 
; mail that may be waiting.  This works by comparing
; the current time to the time of the last call to your host.  If this calc
; produces a value equal to or larger than DIAL HOURS, then a call is made 
; anyway.  Interactive with MINUTES.
; NO-DIAL HOURS on the other hand, specifies a single time period per day when
; TIGER WON'T dial out at all.

UUCPIN-STAGE: g:\bbs\uuin

; OPTIONAL
; This field allows you to specify an ALTERNATE directory for the TIGER dialer
; to place inbound messages.  If you make this the same as UUCPIN, mail will
; be processed immediately.  If you make this DIFFERENT from UUCPIN, you must
; move these files to UUCPIN either manually or with another program. If this
; variable is not included, it will default to whatever is in UUCPIN.

UUCPOUT-STAGE: g:\bbs\uuout

; OPTIONAL
; This field allows you to specify an ALTERNATE staging directory for the TIGER
; dialer to search for OUTBOUND mail.  If you specify the same directory as 
; UUCPOUT, mail will be sent immediately.  If you specify a different directory,
; you must manually move the files from UUCPOUT to UUCPOUT-STAGE before they can
; be sent.  If specified only mail appearing in UUCPOUT-STAGE directory will be
; sent by the TIGER.  Default to whatever is in UUCPOUT

SPAWN ON RECEIPT: C:\TDBS\APPL_IN /q

; OPTIONAL
; This indicates a type 200 TDBS application that TIGER should spawn in the 
; event that messages are received from the host.  The var data specifies the 
; OPTDATA information used to select the TDBS app to be run.  The app will be 
; spawned immediately after TIGER has done a successful mail session

SPAWN FOR DELIVERY: C:\TDBS\APPL_OUT /q

; OPTIONAL
; This indicates a type 200 TDBS application TIGER should spawn in the event
; that it detects outbound messages in the TBBS data base and scans them out to 
; outbound files in directory specified by UUCPOUT.The var data specifies the 
; OPTDATA information used to select the TDBS app to be run.  The app will be 
; spawned immediately after TIGER has successfully created outbound mail.


FTPMAIL: tims.ctl

; OPTIONAL
; Optional field specifies a file containing PICKUP commands listing directories
; that should be searched for matching files on an FTPMAIL@YOURSITE.COM 
; request.  Default is TIMS.CTL but other file names may be specified.

TOPIC BOARD: lists

; OPTIONAL - Only required for mailing list redirection.
; This field corresponds to the message board defined in CEDIT for mail
; list redirection.  The AREAS.PMP file specifies specific topics on this 
; board for redirection.  The board must be defined in CEDIT as a type TN
; and the spelling and case must match exactly.

TIME ZONE: -0600

; OPTIONAL	
; Optional variable - contents are appended to the date in your outbound messages.
; 
; -0400 Eastern DST
; -0500 Central DST	Eastern ST
; -0600 Mountain DST	Central ST
; -0700 Pacific DST	Mountain ST
; -0800 Pacific ST

LOCALMAIL: yes

; OPTIONAL
; Optional variable determines whether you allow local mail in the Internet board.
; If YES, TIGER will only scan out messages containing !,@ or % somewhere in 
; TO field in TBBS.  If no, ALL messages will be scanned out from this board.

SPEED: 35

; OPTIONAL
; Optional variable used to tune TIGER to your system for speed.  Increasing value
; reduces load on system, but also reduces TIGER processing speed.  Decreasing 
; value increases speed, but also increases system loading. Default 35 if not
; specified.  Typically 5-95

REDIAL ATTEMPTS: 7

; OPTIONAL.  Defines number of times TIGER will try to redial a host on busy.
; Default is 3.

SUPPRESS HEADERS: yes

; OPTIONAL.  Default is no.  Suppress display of RFC-822 style headers in all
; e-mail and newsgroup messages.

NEWSHUB: no

; OPTIONAL.  Default is no.  When set to yes activates a more complex directory
; structure to support sorting of mail into different outbound directories for
; pickup by client systems that call TIGER as a host.
